/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GenericDataPoint;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpManager.DatabaseConnection;
import ibm.nways.analysis.dpManager.DatabaseInfo;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Vector;

class DatabaseWorker
implements Runnable {
    private Thread serviceThread;
    private Date theDate;
    private Time theTime;
    private String updateTableSQL;
    private String valuesSQL;
    private DatabaseConnection refDBC;
    private boolean singleInsert = false;

    public DatabaseWorker(DatabaseConnection databaseConnection) {
        this.refDBC = databaseConnection;
        this.theDate = new Date(0, 0, 0);
        this.theTime = new Time(0, 0, 0);
        this.updateTableSQL = new String("INSERT INTO D");
        this.valuesSQL = new String(" VALUES (");
        this.serviceThread = new Thread(this);
        this.serviceThread.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Object object;
                    if ((object = this.refDBC.getNextWork()) instanceof PollingObjectInstance) {
                        this.putHistory((PollingObjectInstance)object);
                        continue;
                    }
                    if (object instanceof Vector) {
                        this.putEvents((Vector)object);
                        continue;
                    }
                    if (object instanceof String && ((String)object).startsWith("SHUTDOWN")) break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        this.refDBC.refServer.cleanupDatabaseConnection();
    }

    public void putEvents(Vector vector) throws SQLException {
        try {
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            int n = 0;
            if (!this.refDBC.isAccess()) {
                n = (int)(0.8 * (double)this.refDBC.getMaxSQL());
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                PerformanceEvent performanceEvent = (PerformanceEvent)enumeration.nextElement();
                this.theDate.setTime(performanceEvent.getEventTime());
                this.theTime.setTime(performanceEvent.getEventTime());
                String string = this.theDate.toString();
                String string2 = this.theTime.toString();
                if (performanceEvent.getEventType() == 64 && performanceEvent.getCause() != 4) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer("INSERT INTO " + DatabaseConnection.POL_EVENT_DATA + " VALUES ");
                    }
                    stringBuffer.append("('" + performanceEvent.getHostname() + "','");
                    stringBuffer.append(String.valueOf(performanceEvent.getEventName()) + "','");
                    stringBuffer.append(String.valueOf(PerformanceEvent.toString(performanceEvent.getCause())) + "',");
                    stringBuffer.append("'" + string + "," + string2 + "',");
                    object = performanceEvent.getDataPoint();
                    stringBuffer.append(String.valueOf(Double.toString(performanceEvent.getEventTime())) + ",");
                    if (object != null && ((GenericDataPoint)object).getID() != null) {
                        stringBuffer.append("'" + ((GenericDataPoint)object).getID() + "' , ");
                    } else {
                        stringBuffer.append("'0', ");
                    }
                    if (object != null && ((DataPoint)object).getValue() != Float.NEGATIVE_INFINITY) {
                        stringBuffer.append(String.valueOf(Double.toString(((DataPoint)object).getValue())) + ",");
                    } else {
                        stringBuffer.append(" 0, ");
                    }
                    stringBuffer.append("'" + Long.toString(performanceEvent.getIndex()) + "')");
                    Statement statement = null;
                    try {
                        statement = this.refDBC.getConnection().createStatement();
                        statement.executeUpdate(stringBuffer.toString());
                        stringBuffer = null;
                        statement.close();
                    }
                    catch (Exception exception) {
                        DatabaseConnection.logError(stringBuffer.toString(), exception);
                        DatabaseConnection.logError("Exception occurred: the SQL string was: \n\n" + stringBuffer.toString(), null);
                        stringBuffer = null;
                        statement.close();
                    }
                    continue;
                }
                if (performanceEvent.getEventType() != 32 || performanceEvent.getCause() == 4) continue;
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer("INSERT INTO " + DatabaseConnection.RES_EVENT_DATA + " VALUES ");
                }
                stringBuffer2.append("('" + performanceEvent.getHostname() + "','");
                stringBuffer2.append(String.valueOf(performanceEvent.getEventName()) + "','");
                stringBuffer2.append(String.valueOf(PerformanceEvent.toString(performanceEvent.getCause())) + "',");
                stringBuffer2.append("'" + string + "," + string2 + "',");
                stringBuffer2.append(String.valueOf(Double.toString(performanceEvent.getEventTime())) + ")");
                object = null;
                try {
                    object = this.refDBC.getConnection().createStatement();
                    object.executeUpdate(stringBuffer2.toString());
                    stringBuffer2 = null;
                    object.close();
                }
                catch (Exception exception) {
                    DatabaseConnection.logError(stringBuffer2.toString(), exception);
                    DatabaseConnection.logError("Exception occurred: the SQL string was: \n\n" + stringBuffer2.toString(), null);
                    stringBuffer2 = null;
                    object.close();
                }
            }
            return;
        }
        catch (Exception exception) {
            DatabaseConnection.logError("", exception);
            return;
        }
    }

    public void putHistory(PollingObjectInstance pollingObjectInstance) throws SQLException, IOException {
        int n = this.refDBC.getDataKey(pollingObjectInstance.getIdentifier(), pollingObjectInstance.getHostname());
        int n2 = 1;
        n2 = n != -1 ? n : this.refDBC.createNewTable(pollingObjectInstance);
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(String.valueOf(this.updateTableSQL) + Integer.toString(n2) + this.valuesSQL);
        System.currentTimeMillis();
        int n3 = 0;
        int n4 = 0;
        if (!this.refDBC.isAccess()) {
            n3 = (int)(0.8 * (double)this.refDBC.getMaxSQL());
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        DataPoint dataPoint = null;
        Enumeration enumeration = pollingObjectInstance.getHistory().elements();
        while (enumeration.hasMoreElements()) {
            dataPoint = (DataPoint)enumeration.nextElement();
            if (Float.isNaN(dataPoint.getValue()) || dataPoint.getValue() == Float.NEGATIVE_INFINITY || Float.isInfinite(dataPoint.getValue())) continue;
            if (dataPoint.getID() != null) {
                stringBuffer2.append("'" + dataPoint.getID() + "' , ");
            } else {
                stringBuffer2.append("'0',");
            }
            this.theDate.setTime(dataPoint.getDate());
            this.theTime.setTime(dataPoint.getDate());
            String string = this.theDate.toString();
            String string2 = this.theTime.toString();
            stringBuffer2.append("'" + string + "," + string2 + "' , ");
            stringBuffer2.append(String.valueOf(Double.toString(dataPoint.getValue())) + ",");
            stringBuffer2.append(String.valueOf(Double.toString(dataPoint.getDate())) + ")");
            ++n4;
            if (stringBuffer2.toString().length() > n3 || this.singleInsert || !enumeration.hasMoreElements()) {
                Statement statement = null;
                try {
                    statement = this.refDBC.getConnection().createStatement();
                    statement.executeUpdate(stringBuffer2.toString());
                    stringBuffer2 = new StringBuffer(stringBuffer.toString());
                    statement.close();
                }
                catch (Exception exception) {
                    DatabaseInfo databaseInfo;
                    if (this.trySingleStatement(statement, stringBuffer2.toString())) {
                        this.singleInsert = true;
                        enumeration = pollingObjectInstance.getHistory().elements();
                        databaseInfo = null;
                        if (enumeration.hasMoreElements()) {
                            DatabaseConnection.logError("Adjusting to next data point...", null);
                            databaseInfo = enumeration.nextElement();
                        }
                        DatabaseConnection.logError("Finished switching to single insert mode.", null);
                    } else if (exception.getMessage().indexOf("SQL0968") > 0) {
                        if (this.refDBC.collecting) {
                            try {
                                databaseInfo = (DatabaseInfo)this.refDBC.clone();
                                databaseInfo.collecting = false;
                                this.refDBC.refServer.setCollectionStatus(databaseInfo);
                            }
                            catch (Exception exception2) {
                                DatabaseConnection.logError("", exception2);
                            }
                        }
                    } else {
                        DatabaseConnection.logError(pollingObjectInstance.toString(), exception);
                        DatabaseConnection.logError("Exception occurred: the SQL string was: \n\n" + stringBuffer2.toString(), null);
                    }
                    stringBuffer2 = new StringBuffer(stringBuffer.toString());
                    statement.close();
                }
                continue;
            }
            stringBuffer2.append(",(");
        }
    }

    private boolean trySingleStatement(Statement statement, String string) {
        DatabaseConnection.logError("Trying single insert statement..", null);
        int n = string.indexOf(")");
        boolean bl = true;
        if (n > 0) {
            String string2 = string.substring(0, n + 1);
            try {
                statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

